package gov.va.med.mhv.admin.service.mhvusers;

import java.util.List;

import javax.ws.rs.core.Response;

import gov.va.med.mhv.admin.dto.InPersonAuthenticationCriteriaDTO;
import gov.va.med.mhv.admin.dto.SMSUserViewDTO;
import gov.va.med.mhv.admin.dto.TermsConditionsVerHistDTO;
import gov.va.med.mhv.admin.dto.UserAcceptExtTermsVerDTO;
import gov.va.med.mhv.admin.dto.UserAcceptTermsHistDTO;
import gov.va.med.mhv.admin.dto.UserEmailAddressHistoryDTO;
import gov.va.med.mhv.admin.dto.UserProfileDeactivationAuditDTO;
import gov.va.med.mhv.common.api.dto.PatientInformationDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDeactivationReasonDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.api.dto.FacilityPreferenceDTO;
import gov.va.med.mhv.common.api.dto.PatientDTO;

public interface UserProfileService {
	
	public List<FacilityPreferenceDTO> getPreferredTreatmentFacilityList(PatientDTO patientDTO) throws MHVException;

	public List<UserProfileDTO> searchUserExtended(UserProfileDTO userProfileDTO) throws MHVException;
	
	public List<UserProfileDTO> searchBasicUserExtended(UserProfileDTO userProfileDTO) throws MHVException;	

	public List<PatientInformationDTO> searchUserIPAExtended(InPersonAuthenticationCriteriaDTO criteriaDTO) throws MHVException;
		
	public UserProfileDTO findUserProfileById(Long userProfileId) throws MHVException;
	
	public ResponseUtil<UserProfileDTO> findUserByUserId(Long userProfileId) throws MHVException;
	
	public void resetPassword(String userName, String newPassword) throws MHVException;
	
	public void savePasswordHistory(Long userProfileId, String userName, String newPassword) throws MHVException;	

	public ResponseUtil<List<UserProfileDeactivationAuditDTO>> findUserProfileDeactivationAuditByUser(Long userProfileId)
			throws MHVException;

	public Boolean userhasDeletedAccount(Long userProfileId) throws MHVException;

	public ResponseUtil<UserProfileDTO> restrictSipAccess(UserProfileDTO userProfile) throws MHVException;

	public ResponseUtil<UserProfileDTO> reactivateUserInHelpDesk(Long userProfileId, Integer reasonId, String changedBy, UserProfileDTO notes) throws MHVException;

	public ResponseUtil<UserProfileDTO> changeActivationState(Long userProfileId, Integer reasonId, String changedBy, UserProfileDTO notes,Boolean isActivate)
			throws MHVException;

	public ResponseUtil<SMSUserViewDTO> getSMUser(String userName) throws MHVException;

	public ResponseUtil<UserProfileDeactivationReasonDTO> findDeactivationReason(Integer reasonId) throws MHVException;
	
	public ResponseUtil<List<UserAcceptTermsHistDTO>> findUserAcceptTermsHistByUserProfileId(Long userProfileId) throws MHVException;
	
	public ResponseUtil<List<TermsConditionsVerHistDTO>> findTermsConditionsVerHistById(Long termsConditionsVerHistId) throws MHVException;

	public ResponseUtil<List<UserAcceptExtTermsVerDTO>> findUserAcceptExtTermsVerByUserProfileId(Long userProfileId) throws MHVException;
	
	public ResponseUtil<List<UserEmailAddressHistoryDTO>>findUserEmailAddressHistoryByProfileId(Long userProfileId) throws MHVException;
	
	public void updateUserEmailAddress(Long userProfileId, String emailAddress, String changedBy, String reason) throws MHVException;

	public void deleteUserEmailAddress(Long userProfileId, String changedBy, String reason) throws MHVException;

	public String getVapiiFormStatusForUser(Long userProfileId) throws MHVException;
	
	public Response downloadVapiiFormForUser(Long userProfileId, String fileFormat) throws MHVException;

}
